const ShardAttributeManager = {

  BASE: {
    attackDamage: 1,
    attackSpeed: 4,
    attackRange: 3
  },

  SHARDS: {
    "kubejs:attack_damage_shard_one": { type: "attackDamage", value: 0.25, color: "§c" },
    "kubejs:attack_damage_shard_two": { type: "attackDamage", value: 0.5,  color: "§c" },
    "kubejs:attack_damage_shard_three": { type: "attackDamage", value: 1,    color: "§c" },
    "kubejs:attack_damage_shard_four": { type: "attackDamage", value: 2.5,  color: "§c" },
    "kubejs:attack_damage_shard_five": { type: "attackDamage", value: 5,    color: "§c" },

    "kubejs:attack_speed_shard_one": { type: "attackSpeed", value: 0.05, color: "§d" },
    "kubejs:attack_speed_shard_two": { type: "attackSpeed", value: 0.1,  color: "§d" },
    "kubejs:attack_speed_shard_three": { type: "attackSpeed", value: 0.25,color: "§d" },
    "kubejs:attack_speed_shard_four": { type: "attackSpeed", value: 0.5, color: "§d" },
    "kubejs:attack_speed_shard_five": { type: "attackSpeed", value: 1,   color: "§d" },

    "kubejs:attack_range_shard_one": { type: "attackRange", value: 0.05, color: "§b" },
    "kubejs:attack_range_shard_two": { type: "attackRange", value: 0.1,  color: "§b" },
    "kubejs:attack_range_shard_three": { type: "attackRange", value: 0.25,color: "§b" },
    "kubejs:attack_range_shard_four": { type: "attackRange", value: 0.5, color: "§b" }
  },

  getData(server, player) {
    if (!server.persistentData.shardBonuses)
      server.persistentData.shardBonuses = {}

    const uuid = player.uuid.toString()

    if (!server.persistentData.shardBonuses[uuid]) {
      server.persistentData.shardBonuses[uuid] = {
        attackDamage: 0,
        attackSpeed: 0,
        attackRange: 0
      }
    }

    return server.persistentData.shardBonuses[uuid]
  },

  apply(player, server) {
    const s = this.getData(server, player)

    server.runCommandSilent(
      `attribute ${player.username} minecraft:generic.attack_damage base set ${this.BASE.attackDamage + s.attackDamage}`
    )
    server.runCommandSilent(
      `attribute ${player.username} minecraft:generic.attack_speed base set ${this.BASE.attackSpeed + s.attackSpeed}`
    )
    server.runCommandSilent(
      `attribute ${player.username} forge:reach_distance base set ${this.BASE.attackRange + s.attackRange}`
    )
  },

  addShard(player, server, itemId) {
    const shard = this.SHARDS[itemId]
    if (!shard) return

    const data = this.getData(server, player)
    data[shard.type] += shard.value

    this.apply(player, server)

    player.tell(`${shard.color}${shard.type.replace("attack", "Attack ")} +${shard.value}`)
  }
}

/* ================= EVENTS ================= */

ItemEvents.foodEaten(e => {
  ShardAttributeManager.addShard(e.player, e.server, e.item.id)
})

PlayerEvents.respawned(e => {
  ShardAttributeManager.apply(e.player, e.server)
})

PlayerEvents.loggedIn(e => {
  ShardAttributeManager.apply(e.player, e.server)
})
